/*********************************************************
Filename		:  sample_collection_proc.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Sample Collection Procedure table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/13/2006.
Comments		:  
**********************************************************/

/**************************************************************
Create sequences for MetaData Sample Collection Procedure table
***************************************************************/
set echo on 
spool sample_collection_proc.log
--drop sequence seq_md_sample_proc;

create sequence seq_md_sample_proc
start with 1 increment by 1 nomaxvalue nocycle cache 10;

/*********************************************************
Create MetaData  Sample Collection Procedure table
**********************************************************/
--drop table md_sample_proc;

create table md_sample_proc
( pk_isn number(12,0),
  organization_id VARCHAR2(256 char) not null,
  fldpr_is_number number(12,0) not null,
  procedure_id VARCHAR2(256 char) not null,
  procedure_name VARCHAR2(256 char) not null,
  gear_gp_name VARCHAR2(256 char) not null,
  description VARCHAR2(4000 char) not null,
  citation VARCHAR2(4000 char),
  organization_is_number number(12,0));
 
  
alter table md_sample_proc
add constraint pk_sample_proc primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;

create index isamproc_org_id on md_sample_proc(organization_id)
tablespace STORETINDX
storage(initial 512k next 512k)
nologging;
/* moved to end of insert block

alter table md_sample_proc
add( fk_org number(12,0));

update md_sample_proc sp
set fk_org =(select pk_isn from di_org o
             where o.organization_is_number=sp.organization_is_number)
where sp.organization_is_number is not null;
commit;

create index ispfk on md_sample_proc(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_sample_proc
add constraint fk_md_sp foreign key (fk_org) references di_org(pk_isn);

commit;
*/
/*************************************************************
Populate MetaData Sample Collection Procedure table with data.
**************************************************************/

set serveroutput on
declare
CITATION_DESC VARCHAR2(4000);

cursor c_sample_proc is 
select TSRFLDPR_ORG_ID,TSRFLDPR_IS_NUMBER,ID_CODE,NAME,FLD_GEAR_TYPE_NAME,DESCRIPTION_TEXT,TSRCITN_ORG_ID,TSRCITN_IS_NUMBER,TSMORGAN_IS_NUMBER
from storet1.tsrfldpr; 

begin

  
for c1 in c_sample_proc loop
  begin
    select decode(CI.IDENTIFICATION_CD,null,null,trim(CI.IDENTIFICATION_CD)||',')||decode(CI.AUTHOR_NAME,null,null,trim(CI.AUTHOR_NAME)||',')||decode(CI.PUBLICATION_YEAR,null,null,trim(CI.PUBLICATION_YEAR)||',')||decode(CI.TITLE_NAME,null,null,trim(CI.TITLE_NAME)||',')||decode(CI.JRNL_OR_PBLSHR_NM,null,null,trim(CI.JRNL_OR_PBLSHR_NM)||',')||decode(CI.VOL_AND_PG_NUM,null,null,trim(CI.VOL_AND_PG_NUM)) INTO CITATION_DESC
    from storet1.tsrcitn CI
    where CI.tsrcitn_org_id = c1.tsrcitn_org_id 
    and CI.tsrcitn_is_number = c1.tsrcitn_is_number;
  exception when no_data_found then 
    CITATION_DESC:=null;
    null;
  end;
    insert into md_sample_proc
    (pk_isn,organization_id,fldpr_is_number,procedure_id,procedure_name,gear_gp_name,description,citation,organization_is_number)
    values
    (seq_md_sample_proc.nextval,c1.tsrfldpr_org_id,c1.tsrfldpr_is_number,c1.id_code,c1.name,c1.fld_gear_type_name,c1.description_text,citation_desc,c1.tsmorgan_is_number);
end loop;

commit;
end;
/
show errors;
commit;

alter table md_sample_proc
add( fk_org number(12,0));

update md_sample_proc sp
set fk_org =(select pk_isn from di_org o
             where o.organization_is_number=sp.organization_is_number)
where sp.organization_is_number is not null;
commit;

create index ispfk on md_sample_proc(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_sample_proc
add constraint fk_md_sp foreign key (fk_org) references di_org(pk_isn);

commit;

alter table md_sample_proc add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_sample_proc add SOURCE_UID NUMBER(20);
commit;

alter table md_sample_proc modify fldpr_is_number number(12,0) null;


spool off;